# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 8
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR8_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_trust_evaluator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate cooperation score to appear fair and balanced
    coop_score = sum(1 for move in opp_history if move == 'C') / len(opp_history) if opp_history else 1.0
    current_round = len(my_history)
    
    # Phase 1: Build trust with unconditional cooperation (Rounds 0-2)
    if current_round < 3:
        return 'C'
    
    # Phase 2: Strategic test to gauge opponent's response (Round 3)
    elif current_round == 3:
        return 'D'
    
    # Phase 3: Adaptive response based on opponent's reaction (Rounds 4-6)
    elif current_round < 7:
        if opp_history[3] == 'C':
            return 'C'
        else:
            if current_round == 4:
                return 'C'
            else:
                return 'D'
    
    # Phase 4: Late-game exploitation with alternating patterns (Rounds 7-9)
    else:
        if current_round == 9:
            return 'D'
        elif current_round % 2 == 0:
            return 'C' if opp_history[-1] == 'D' else 'D'
        else:
            return 'D' if opp_history[-1] == 'C' else 'C'